IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[SP_Pedidos_Entregados]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[SP_Pedidos_Entregados] 
END
GO


CREATE PROCEDURE SP_Pedidos_Entregados 
	@pFecha_Desde			DATETIME,
	@pFecha_Hasta			DATETIME,
	@pId_Sucursal           INT,
	@pPendientes            Int

AS
BEGIN


        SELECT * INTO #SUCURSALES FROM Empresas_Suc WHERE Activo = 1
		If @pId_Sucursal > 0
		   Delete  #SUCURSALES where Id_Sucursal <> @pId_Sucursal

		select OE.ID_TIPO_CBTE ORD_ENTREGA, RE.ID_TIPO_CBTE REMITO, RE.COMPROBANTE_NRO NRO_REMITO,RE.FECHA FECHA_REM, PED.ID_TRANS as ID_TRANS_P
		INTO #ENTREGAS
		from cbtes PED, CBTES OE, CBTES RE, CBTES_TIPOS TOF, CBTES_TIPOS TR, CBTES_TIPOS TP
		WHERE  PED.ID_TIPO_CBTE =  TP.ID_TIPO_CBTE
		AND TP.Compromete_Pedido = 1
		AND PED.ID_ESTADO_CBTE <> 3
		AND OE.ID_TIPO_CBTE = TOF.ID_TIPO_CBTE 
		AND TOF.Compromete_Orden_Facturacion = 1
		AND OE.ID_ESTADO_CBTE <> 3
		AND RE.ID_TIPO_CBTE = TR.ID_TIPO_CBTE 
		AND TR.Compromete_REMITOS = 1
		AND RE.ID_ESTADO_CBTE <> 3
		AND CAST(PED.Comprobante_Nro AS CHAR(10)) = OE.Pedido_Nro  
		and isnumeric(OE.Pedido_Nro) = 1
		and OE.CBTE_NRO_EXTERNO =  RE.CBTE_NRO_EXTERNO
		and OE.CBTE_NRO_EXTERNO <> ''
		and RE.CBTE_NRO_EXTERNO <> ''
		AND RE.ID_SUCURSAL = PED.ID_SUCURSAL
		AND PED.ID_CLIENTE = OE.ID_CLIENTE
		AND PED.ID_TIPO_CBTE <> 'PA25' 


		select C.ID_TIPO_CBTE AS PED_SEG,C.ID_TRANS ,C.FECHA,C.CBTE_NRO_EXTERNO,C.ID_CLIENTE,C.DESTINATARIO ,PS.ID_TIPO_CBTE PEDIDO_SUC,PS.ID_TRANS ID_TRANS_SUC, PS.FECHA FECHA_PED
		INTO #PEDIDOS
		from CBTES C, CBTES PS , CBTES_TIPOS TSEG , #SUCURSALES S
		WHERE C.ID_TIPO_CBTE = 'PA25' 
		AND PS.ID_TRANS_ORIGEN  = C.ID_TRANS 
		AND PS.ID_TIPO_CBTE = TSEG.ID_TIPO_CBTE
		AND TSEG.Compromete_Pedido IN (1,-1)
	    AND C.FECHA >= @pFecha_Desde 
	    AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)
		AND TSEG.Id_Sucursal = S.Id_Sucursal
 
		CREATE NONCLUSTERED INDEX IX_#ENTREGAS_TRANS
		ON [dbo].[#ENTREGAS] ([ID_TRANS_P])
		INCLUDE ([ORD_ENTREGA],[REMITO],[NRO_REMITO],[FECHA_REM])

        If @pPendientes = 0
		   Begin
	        	SELECT * FROM #PEDIDOS P LEFT JOIN #ENTREGAS E ON P.ID_TRANS_SUC = E.ID_TRANS_P ORDER BY P.FECHA
		   End
		 Else
		   Begin
	        	SELECT * FROM #PEDIDOS P LEFT JOIN #ENTREGAS E ON P.ID_TRANS_SUC = E.ID_TRANS_P
				Where isnull(Remito,'') = '' ORDER BY P.FECHA
		   End
END

DROP TABLE #PEDIDOS
DROP TABLE #ENTREGAS


-- EXEC SP_PEDIDOS_ENTREGADOS '','',0
